#ifndef _CERT_TLK_ATP_UTIL_H_
#define _CERT_TLK_ATP_UTIL_H_

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/


#ifdef __cplusplus
extern "C"
{
#endif

  /*
  *  Object %name    : %
  *  State           :  %state%
  *  Creation date   :  27-May -08
  *  Last modified   :  %modify_time%
  */
  /** @file
  *  \brief A brief description of this module
  *
  *  \version CERT_TLK_ATP_util.h#1:incl:1
  *  \author SagitB
  *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
  *           All Rights reserved
  */
#ifndef DX_NO_TLK_SCLK_SUPPORT
 /*****************************************************************************
    * Function Name:                                                           
    *  TST_ATP_TLK_CERT_INIT
    * 
    * Inputs:
    *  None
    *
    * Outputs:
    *  DxError_t - Function error return                                        
    *
    * Description:                                                                 
    *    open the database for the secure clock and the secure clock toolkit
    * Algorithm:
    * 1. Crate the DB.
    * 2. If working with SST call SST_Init.
    * 3. Initialize the new master clock descriptor.
    * 4. Generate a new descriptor for secured service clock
    *******************************************************************************/ 
    DxError_t TST_ATP_TLK_CERT_INIT(void);

    /*****************************************************************************
    * Function Name:                                                           
    *  TST_ATP_TLK_CERT_Terminate        
    * 
    * Outputs:
    *  DxError_t - Function error return                                        
    *
    * Description:                                                                 
    * this function Terminate the secure clock and the SST 
    *
    ******************************************************************************/
    DxError_t TST_ATP_TLK_CERT_Terminate(void);

#endif
  /**
  ****************************************************************
  * Function Name: 
  *  UpdateResponseSignature
  *
  * @param aResponsePtr      [in/out] - Pointer to the OCSP response
  *        object buffer in DER format to be processed;
  * @param aResponseLength   [in]     - OCSP response length;
  * @param aRSAPrivateKeyPtr [in]     - Pointer to the RSA private
  *        key object in DER format;
  * @param aRSAPrivateKeyDataLength [in] - RSA private key buffer size;
  * @param aNoncePtr         [in]     - Pointer to the nonce buffer
  *        that'll be written to current OCSP response overriding old;
  * @param aNonceLength   [in]     - OCSP response length;
  *
  *
  * @returns \b
  *  bool 
  *  - true  - The operation completed successfully;
  *  - false - The operation failed.
  *
  * \brief \b 
  * Description:
  *  This function gets OCSP response in DER format, private RSA key
  *  with using which response was signed (or another RSA key to be
  *  used), nonce buffer that contains new nonce and nonce size to
  *  replace old nonce value and than signs modified OCSP response.
  *
  * \note
  *  Function fails when:
  *  - OCSP response ASN1 object structure is invalid:
  *    - corrupted;
  *    - doesn't contains response data that is optional;
  *    - doesn't contains signature;
  *    - doesn't contains nonce extension;
  *  - OCSP contains not supported data: HASH and key type;
  *  - OCSP response nonce extension data size doesn't match input
  *    nonce size;
  *
  * \b 
  * Algorithm:
  *  -# Validate input pointers;
  *  -# Validate RSA private key ASN1 object and build using CRYS
  *     function CRYS_RSA_Build_PrivKey;
  *  -# Validate OCSP response ASN1 object;
  *  -# Find and replace nonce extension value;
  *  -# Validate signature algorithm: HASH and key type:
  *     supported only (CRYS) SHA1, MD5 and RSA key encryption;
  *  -# Sign OCSP response using CRYS function _DX_RSA_Sign.
  ***************************************************************/
  DxUint32_t UpdateResponseSignature(
    DxUint8_t	*aResponsePtr,
    DxUint8_t	*aRSAPrivateKeyPtr,
    DxUint8_t	*aNoncePtr,
    DxUint32_t	aNonceLength);


#ifdef __cplusplus
}
#endif

#endif